function CDX = set_zero_RP_J_idio(CDX, param1, param2, param_type)
% --------------------------------------------------------------------------------------------------
% Set the market price of idiosyncratic jump risk equal to zero
% --------------------------------------------------------------------------------------------------
% CDX                           ... credit index structure (see 'all_steps_in_a_row.m')
% l_P                           ... idiosyncratic jump intensity under P
% mu_P                          ... idiosyncratic expected jump size under P
% param_type                    ... type of physical parameters
%                                   1 ... (l, mu)
%                                   2 ... (l, omega4)        where mu_i^P = omega4 * X_it
%                                   3 ... (omega5, omega4)   where mu_i^P = omega4 * X_it and l_i^P = omega5 * X_it
% --------------------------------------------------------------------------------------------------
% sample call: set_zero_RP_J_idio(cdx_tv_monthly10, 0.5, 0.002, 1)
% --------------------------------------------------------------------------------------------------

for i=1:length(CDX.portfolio)
    cds = CDX.portfolio(i);
    
    % Set jump intensity
    if (param_type == 1) | (param_type == 2)
        cds.AJD.L = repmat(param1, size(cds.AJD.L)); 
    elseif (param_type == 3)
       cds.AJD.L = cds.x0 * param1;
    end
    
    % Set expected jump size
    if (param_type == 1)
        cds.AJD.mu = repmat(param2, size(cds.AJD.mu));
    elseif (param_type == 2) | (param_type == 3)
        cds.AJD.mu = cds.x0 * param2;
    end
    CDX.portfolio(i) = cds;
end